<?php
/**
 * Template part for displaying slider section
 *
 * @package Gym Club
 * @subpackage gym_club
 */

$gym_club_static_image = get_stylesheet_directory_uri() . '/assets/images/header_img.png';

if (get_theme_mod('gym_club_slider_arrows', true) != '') : ?>

<section id="slider">
  <div id="owl-carousel" class="owl-carousel">
    <?php
    $gym_club_slide_pages = array();
    for ($gym_club_count = 1; $gym_club_count <= 4; $gym_club_count++) {
        $gym_club_mod = intval(get_theme_mod('gym_club_slider_page' . $gym_club_count, 0));
        if ($gym_club_mod > 0) {
            $gym_club_slide_pages[] = $gym_club_mod;
        }
    }

    if (!empty($gym_club_slide_pages)) :
        $gym_club_args = array(
            'post_type' => 'page',
            'post__in' => $gym_club_slide_pages,
            'orderby' => 'post__in'
        );
        $gym_club_query = new WP_Query($gym_club_args);
        if ($gym_club_query->have_posts()) :
            while ($gym_club_query->have_posts()) : $gym_club_query->the_post(); ?>
                <div class="item">
                    <div class="slider-border">
                        <?php if (has_post_thumbnail()) { ?>
                            <img src="<?php echo esc_url(get_the_post_thumbnail_url(get_the_ID(), 'full')); ?>" alt="<?php the_title_attribute(); ?>" />
                        <?php } else { ?>
                            <img src="<?php echo esc_url($gym_club_static_image); ?>" alt="<?php esc_attr_e('Default Image', 'gym-club'); ?>" />
                        <?php } ?>
                    </div>
                    <div class="carousel-caption">
                        <div class="slider-main-content">
                            <div class="inner-text inner_carousel">
                                <h1 class="text-uppercase mb-0 pt-3"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h1>
                                <div class="highlight-slider">
                                    <div class="text-with-icon">
                                        <?php $gym_club_short_heading = get_theme_mod('gym_club_slider_short_heading', '');
                                        $gym_club_slider_play_url = get_theme_mod('gym_club_slider_play_url', '');
                                        if (!empty($gym_club_short_heading)) { ?>
                                            <p class="slidetop-text m-0"><?php echo esc_html($gym_club_short_heading); ?></p>
                                        <?php } ?>

                                        <?php if ($gym_club_slider_play_url) : ?>
                                            <a href="<?php echo esc_url($gym_club_slider_play_url); ?>" class="youtube-icon-overlay" target="_blank">
                                                <i class="fas fa-play"></i>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <p class="mb-0 slider-content"><?php echo esc_html(wp_trim_words(get_the_content(), 18)); ?></p>
                                <div class="more-btn mt-md-4 mt-2 pb-3">
                                    <?php 
                                        // Get the button text and link from the theme settings.
                                        $gym_club_btn_text1 = get_theme_mod('gym_club_btn_text1', __('JOIN FREE 3 DAYS TRIAL', 'gym-club'));
                                        $gym_club_btn_link1 = get_theme_mod('gym_club_btn_link1', '');

                                        // Fallback to the permalink if no link is provided.
                                        $gym_club_button_link = !empty($gym_club_btn_link1) ? $gym_club_btn_link1 : get_permalink();

                                        // Display the button.
                                        if (!empty($gym_club_btn_text1)) { ?>
                                            <a href="<?php echo esc_url($gym_club_button_link); ?>" target="_blank" class="text-capitalize me-2 mb-2 slider-btn1">
                                                <?php echo esc_html($gym_club_btn_text1); ?>
                                                <span class="screen-reader-text"><?php echo esc_html($gym_club_btn_text1); ?></span>
                                            </a>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endwhile;
            wp_reset_postdata();
        else : ?>
            <div class="no-postfound"><?php esc_html_e('No slides found.', 'gym-club'); ?></div>
        <?php endif;
    endif; ?>
  </div>
</section>
<?php endif; ?>