<?php
/**
 * Template part for displaying the services section.
 *
 * @package Gym Club
 * @subpackage gym_club
 */

// Check if the services section is enabled.
$gym_club_our_servs = get_theme_mod('gym_club_our_servs_setting', true);

if ($gym_club_our_servs == '1') {
?>
<section id="our-services" class="py-5 px-md-0 px-3">
    <div class="container">
        <div class="text-center main-sec-title">
            <?php if (get_theme_mod('gym_club_offer_section_tittle')) { ?>
                <p class="my-2 text-center text-uppercase serv-top-title">
                    <?php echo esc_html(get_theme_mod('gym_club_offer_section_tittle')); ?>
                </p>
            <?php } ?>
        </div>
        <?php if (get_theme_mod('gym_club_offer_section_text')) { ?>
            <h2 class="text-center px-md-5 serv-top-head text-uppercase">
                <?php echo esc_html(get_theme_mod('gym_club_offer_section_text')); ?>
            </h2>
        <?php } ?>

        <div class="row mt-4">
            <?php
            // Fetch selected category and the number of posts to show.
            $gym_club_post_category = get_theme_mod('gym_club_offer_section_category', 'select');
            $gym_club_posts_to_show = absint(get_theme_mod('gym_club_posts_to_show', 4));

            // Validate category selection.
            if ($gym_club_post_category !== 'select') {
                // Query posts from the selected category.
                $gym_club_page_query = new WP_Query(array(
                    'category_name'  => esc_html($gym_club_post_category),
                    'posts_per_page' => $gym_club_posts_to_show,
                ));

                if ($gym_club_page_query->have_posts()) {
                    // Loop through the posts.
                    while ($gym_club_page_query->have_posts()) : $gym_club_page_query->the_post();
            ?>
                        <div class="col-lg-3 col-md-4 mb-4">
                            <div class="cat-inner-box">
                                <?php if (has_post_thumbnail()) : ?>
                                    <img src="<?php echo esc_url(get_the_post_thumbnail_url()); ?>" alt="<?php the_title_attribute(); ?>" />
                                <?php endif; ?>
                                <div class="mainserv-content">
                                    <div class="icon-main">
                                        <?php
                                        // Fetch icon class or set default.
                                        $gym_club_icon_class = get_theme_mod('gym_club_services_icon' . ($gym_club_page_query->current_post + 1), 'fas fa-heartbeat');
                                        ?>
                                        <i class="<?php echo esc_attr($gym_club_icon_class); ?>"></i>
                                    </div>
                                    <div class="bottom-content">
                                        <h3 class="text-uppercase">
                                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                        </h3>
                                        <hr>
                                        <div class="post-read-btn">
                                            <a href="<?php the_permalink(); ?>"><?php esc_html_e('More Info', 'gym-club'); ?></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endwhile;
                    wp_reset_postdata(); // Reset post data after custom query.
                } else {
                    // No posts found.
                    echo '<div class="no-postfound">' . esc_html__('No Post found.', 'gym-club') . '</div>';
                }
            } else {
                // No category selected.
                echo '<div class="no-postfound">' . esc_html__('No category selected.', 'gym-club') . '</div>';
            }
            ?>
        </div>
    </div>
</section>
<?php
}
?>