<?php
/*
* Display header
*/
?>

<div class="headerbox">
    <div class="header-main">
        <?php if (get_theme_mod('gym_club_topbar_visibility', true)) : ?>
            <div class="top-main py-2">
                <div class="container">
                    <div class="row m-0">
                        <div class="col-lg-8 col-md-9 align-self-center p-md-0">
                            <div class="contact">
                                <?php if (get_theme_mod('gym_club_location')) : ?>
                                    <p class="mb-md-0 mb-2 contact-content me-lg-5 me-md-3">
                                        <i class="fas fa-compass me-2"></i><span><?php echo esc_html__('Address:', 'gym-club'); ?></span> <?php echo esc_html(get_theme_mod('gym_club_location')); ?>
                                    </p>
                                <?php endif; ?>
                                <?php if (get_theme_mod('gym_club_call')) : ?>
                                    <p class="mb-md-0 mb-2 contact-content call me-lg-5 me-md-3">
                                        <i class="fas fa-phone me-md-2 me-1"></i><span><?php echo esc_html__('Call:', 'gym-club'); ?></span> <a href="tel:<?php echo esc_html(get_theme_mod('gym_club_call')); ?>">
                                                <?php echo esc_html(get_theme_mod('gym_club_call')); ?>
                                        </a>
                                    </p>
                                <?php endif; ?>
                                <?php if (get_theme_mod('gym_club_mail')) : ?>
                                    <p class="mb-md-0 mb-2 contact-content">
                                        <i class="far fa-envelope me-md-2 me-1"></i><span><?php echo esc_html__('Email:', 'gym-club'); ?></span> <a href="mailto:<?php echo esc_html(get_theme_mod('gym_club_mail')); ?>">
                                            <?php echo esc_html(get_theme_mod('gym_club_mail')); ?>
                                        </a>
                                    </p>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-3 align-self-center p-md-0">
                            <div class="social-media text-md-end text-center">
                                <?php
                                $gym_club_ins_url = get_theme_mod('gym_club_instagram_url');
                                $gym_club_linkedin_url = get_theme_mod('gym_club_linkedin_url');
                                $gym_club_twt_url = get_theme_mod('gym_club_twitter_url');
                                $gym_club_youtube_url = get_theme_mod('gym_club_youtube_url');

                                $gym_club_ins_new_tab = esc_attr(get_theme_mod('gym_club_header_ins_new_tab', 'true'));
                                $gym_club_linkedin_new_tab = esc_attr(get_theme_mod('gym_club_header_linkedin_new_tab', 'true'));
                                $gym_club_twt_new_tab = esc_attr(get_theme_mod('gym_club_header_twt_new_tab', 'true'));
                                $gym_club_youtube_new_tab = esc_attr(get_theme_mod('gym_club_youtube_new_tab', 'true'));

                                if ($gym_club_ins_url || $gym_club_linkedin_url || $gym_club_twt_url || $gym_club_youtube_url) : ?>
                                    
                                    <?php if ($gym_club_ins_url) : ?>
                                        <a <?php if ($gym_club_ins_new_tab != false) : ?>target="_blank" <?php endif; ?>href="<?php echo esc_url($gym_club_ins_url); ?>"><i class="me-lg-3 me-2  <?php echo esc_attr(get_theme_mod('gym_club_instagram_icon', 'fab fa-instagram')); ?>"></i></a>
                                    <?php endif; ?>

                                    <?php if ($gym_club_linkedin_url) : ?>
                                        <a <?php if ($gym_club_linkedin_new_tab != false) : ?>target="_blank" <?php endif; ?>href="<?php echo esc_url($gym_club_linkedin_url); ?>"><i class="me-lg-3 me-2 <?php echo esc_attr(get_theme_mod('gym_club_linkedin_icon', 'fab fa-linkedin')); ?>"></i></a>
                                    <?php endif; ?>
                                    
                                    <?php if ($gym_club_twt_url) : ?>
                                        <a <?php if ($gym_club_twt_new_tab != false) : ?>target="_blank" <?php endif; ?>href="<?php echo esc_url($gym_club_twt_url); ?>"><i class="me-lg-3 me-2 <?php echo esc_attr(get_theme_mod('gym_club_twitter_icon', 'fab fa-twitter')); ?>"></i></a>
                                    <?php endif; ?>

                                    <?php if ($gym_club_youtube_url) : ?>
                                        <a <?php if ($gym_club_youtube_new_tab != false) : ?>target="_blank" <?php endif; ?>href="<?php echo esc_url($gym_club_youtube_url); ?>"><i class="<?php echo esc_attr(get_theme_mod('gym_club_youtube_icon', 'fab fa-youtube')); ?>"></i></a>
                                    <?php endif; ?>
                                    
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        
        <div class="position-relative">
            <div class="below-header">
                <div class="container">
                    <div class="menu-box">
                        <div class="logo text-center">
                            <?php if (has_custom_logo()) : ?>
                                <?php the_custom_logo(); ?>
                            <?php endif; ?>

                            <?php if (get_theme_mod('gym_club_site_title', true)) : ?>
                                <?php if (is_front_page() && is_home()) : ?>
                                    <p class="text-capitalize mb-0">
                                        <a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
                                    </p>
                                <?php else : ?>
                                    <h1 class="text-capitalize">
                                        <a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
                                    </h1>
                                <?php endif; ?>
                            <?php endif; ?>

                            <?php
                            $gym_club_description = get_bloginfo('description', 'display');
                            if ($gym_club_description || is_customize_preview()) :
                                if (get_theme_mod('gym_club_site_tagline', false)) :
                                    ?>
                                    <p class="site-description my-1 text-capitalize"><?php echo esc_html($gym_club_description); ?></p>
                                <?php endif; 
                            endif;
                            ?>
                        </div>
                        <div class="main-navhead">
                            <div class="menu-content">
                                <?php get_template_part('template-parts/navigation/site-nav'); ?>
                            </div>
                        </div>
                        <div class="head-btn">
                            <?php if (get_theme_mod('gym_club_header_link') || get_theme_mod('gym_club_header_button','GET STARTED FOR FREE')) : ?>
                                <div class="header-btn text-center">
                                    <a href="<?php echo esc_url(get_theme_mod('gym_club_header_link')); ?>" class="book-appoin"><?php echo esc_html(get_theme_mod('gym_club_header_button','GET STARTED FOR FREE')); ?></a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>