<?php

$classic_cosmetics_first_color = get_theme_mod('classic_cosmetics_first_color');
$classic_cosmetics_color_scheme_css = '';


/*------------------ Global First Color -----------*/

if ($classic_cosmetics_first_color) {
  $first_color_rgb = implode(',', sscanf($classic_cosmetics_first_color, "#%02x%02x%02x"));
  $classic_cosmetics_color_scheme_css .= ':root {';
  $classic_cosmetics_color_scheme_css .= '--first-theme-color: ' . esc_attr($classic_cosmetics_first_color) . ' !important;';
  $classic_cosmetics_color_scheme_css .= '--first-theme-color-rgb: ' . esc_attr($first_color_rgb) . ';';
  $classic_cosmetics_color_scheme_css .= '} ';
}
  
//---------------------------------Logo-Max-height--------- 
$classic_cosmetics_logo_width = get_theme_mod('classic_cosmetics_logo_width');

if($classic_cosmetics_logo_width != false){

$classic_cosmetics_color_scheme_css .='.logo img{';

  $classic_cosmetics_color_scheme_css .='width: '.esc_html($classic_cosmetics_logo_width).'px;';

$classic_cosmetics_color_scheme_css .='}';
}

/*---------------------------Slider Height ------------*/

$classic_cosmetics_slider_img_height = get_theme_mod('classic_cosmetics_slider_img_height');
if($classic_cosmetics_slider_img_height != false){
    $classic_cosmetics_color_scheme_css .='.slidesection img{';
        $classic_cosmetics_color_scheme_css .='height: '.esc_attr($classic_cosmetics_slider_img_height).' !important;';
    $classic_cosmetics_color_scheme_css .='}';
}

/*--------------------------- Footer background image -------------------*/

$classic_cosmetics_footer_bg_image = get_theme_mod('classic_cosmetics_footer_bg_image');
if($classic_cosmetics_footer_bg_image != false){
    $classic_cosmetics_color_scheme_css .='.footer-widget{';
        $classic_cosmetics_color_scheme_css .='background: url('.esc_attr($classic_cosmetics_footer_bg_image).')!important;';
        $classic_cosmetics_color_scheme_css .= 'background-size: cover!important;';    
    $classic_cosmetics_color_scheme_css .='}';
}

/*--------------------------- Scroll to top positions -------------------*/

$classic_cosmetics_scroll_position = get_theme_mod( 'classic_cosmetics_scroll_position','Right');
if($classic_cosmetics_scroll_position == 'Right'){
    $classic_cosmetics_color_scheme_css .='#button{';
        $classic_cosmetics_color_scheme_css .='right: 20px;';
    $classic_cosmetics_color_scheme_css .='}';
}else if($classic_cosmetics_scroll_position == 'Left'){
    $classic_cosmetics_color_scheme_css .='#button{';
        $classic_cosmetics_color_scheme_css .='left: 20px;';
    $classic_cosmetics_color_scheme_css .='}';
}else if($classic_cosmetics_scroll_position == 'Center'){
    $classic_cosmetics_color_scheme_css .='#button{';
        $classic_cosmetics_color_scheme_css .='right: 50%;left: 50%;';
    $classic_cosmetics_color_scheme_css .='}';
}

/*--------------------------- Blog Post Page Image Box Shadow -------------------*/

$classic_cosmetics_blog_post_page_image_box_shadow = get_theme_mod('classic_cosmetics_blog_post_page_image_box_shadow',0);
if($classic_cosmetics_blog_post_page_image_box_shadow != false){
    $classic_cosmetics_color_scheme_css .='.blog-post .post-thumb img{';
        $classic_cosmetics_color_scheme_css .='box-shadow: '.esc_attr($classic_cosmetics_blog_post_page_image_box_shadow).'px '.esc_attr($classic_cosmetics_blog_post_page_image_box_shadow).'px '.esc_attr($classic_cosmetics_blog_post_page_image_box_shadow).'px #cccccc;';
    $classic_cosmetics_color_scheme_css .='}';
}

/*--------------------------- Single Post Page Image Box Shadow -------------------*/

$classic_cosmetics_single_post_page_image_box_shadow = get_theme_mod('classic_cosmetics_single_post_page_image_box_shadow',0);
if($classic_cosmetics_single_post_page_image_box_shadow != false){
    $classic_cosmetics_color_scheme_css .='.single-post img{';
        $classic_cosmetics_color_scheme_css .='box-shadow: '.esc_attr($classic_cosmetics_single_post_page_image_box_shadow).'px '.esc_attr($classic_cosmetics_single_post_page_image_box_shadow).'px '.esc_attr($classic_cosmetics_single_post_page_image_box_shadow).'px #cccccc;';
    $classic_cosmetics_color_scheme_css .='}';
}  

/*--------------------------- Woocommerce Product Image Border Radius -------------------*/

$classic_cosmetics_woo_product_img_border_radius = get_theme_mod('classic_cosmetics_woo_product_img_border_radius');
if($classic_cosmetics_woo_product_img_border_radius != false){
    $classic_cosmetics_color_scheme_css .='.woocommerce ul.products li.product a img{';
        $classic_cosmetics_color_scheme_css .='border-radius: '.esc_attr($classic_cosmetics_woo_product_img_border_radius).'px;';
    $classic_cosmetics_color_scheme_css .='}';
}

/*--------------------------- Woocommerce Product Sale Position -------------------*/    

$classic_cosmetics_product_sale_position = get_theme_mod( 'classic_cosmetics_product_sale_position','Left');
if($classic_cosmetics_product_sale_position == 'Right'){
    $classic_cosmetics_color_scheme_css .='.woocommerce ul.products li.product .onsale{';
        $classic_cosmetics_color_scheme_css .='left:auto !important; right:0 !important;';
    $classic_cosmetics_color_scheme_css .='}';
}else if($classic_cosmetics_product_sale_position == 'Left'){
    $classic_cosmetics_color_scheme_css .='.woocommerce ul.products li.product .onsale {';
        $classic_cosmetics_color_scheme_css .='right:auto !important; left:0 !important;';
    $classic_cosmetics_color_scheme_css .='}';
}    

/*--------------------------- Shop page pagination -------------------*/

$classic_cosmetics_wooproducts_nav = get_theme_mod('classic_cosmetics_wooproducts_nav', 'Yes');
if($classic_cosmetics_wooproducts_nav == 'No'){
  $classic_cosmetics_color_scheme_css .='.woocommerce nav.woocommerce-pagination{';
    $classic_cosmetics_color_scheme_css .='display: none;';
  $classic_cosmetics_color_scheme_css .='}';
}

/*--------------------------- Related Product -------------------*/

$classic_cosmetics_related_product_enable = get_theme_mod('classic_cosmetics_related_product_enable',true);
if($classic_cosmetics_related_product_enable == false){
  $classic_cosmetics_color_scheme_css .='.related.products{';
    $classic_cosmetics_color_scheme_css .='display: none;';
  $classic_cosmetics_color_scheme_css .='}';
}

/*--------------------------- Preloader Background Image ------------*/

$classic_cosmetics_preloader_bg_image = get_theme_mod('classic_cosmetics_preloader_bg_image');
if($classic_cosmetics_preloader_bg_image != false){
  $classic_cosmetics_color_scheme_css .='#preloader{';
    $classic_cosmetics_color_scheme_css .='background: url('.esc_attr($classic_cosmetics_preloader_bg_image).'); background-size: cover;';
  $classic_cosmetics_color_scheme_css .='}';
}

/*--------------------------- Scroll to Top Button Shape -------------------*/

$classic_cosmetics_scroll_top_shape = get_theme_mod('classic_cosmetics_scroll_top_shape', 'circle');
if($classic_cosmetics_scroll_top_shape == 'box' ){
    $classic_cosmetics_color_scheme_css .='#button{';
        $classic_cosmetics_color_scheme_css .=' border-radius: 0%';
    $classic_cosmetics_color_scheme_css .='}';
}elseif($classic_cosmetics_scroll_top_shape == 'curved' ){
    $classic_cosmetics_color_scheme_css .='#button{';
        $classic_cosmetics_color_scheme_css .=' border-radius: 20%';
    $classic_cosmetics_color_scheme_css .='}';
}elseif($classic_cosmetics_scroll_top_shape == 'circle' ){
    $classic_cosmetics_color_scheme_css .='#button{';
        $classic_cosmetics_color_scheme_css .=' border-radius: 50%;';
    $classic_cosmetics_color_scheme_css .='}';
}